function sumlyHSFindOptions(ary, keys)
{
	if(typeof ary != 'object' || typeof keys != 'object')
		return undefined;
	var key = keys.shift();
	if(!key in ary)
		return {};
	else if(0 == keys.length)
		return ary[key];
	else
		return sumlyHSFindOptions(ary[key], keys);
}

function sumlyHSUnescapeEntities(str)
{
	var div = document.createElement('div');
	div.innerHTML = str;
	return div.childNodes[0] ? div.childNodes[0].nodeValue : '';
}

function sumlyHSReplaceOptions(ctl, optionList, groupName)
{
	var j = 0;
	ctl.options.length = 0;
	if(sumlyHSPrefix[groupName])
		ctl.options[j++] = new Option(sumlyHSPrefix[groupName], '', false, false);
	for(i in optionList) {
		var optionText = (-1 == String(optionList[i]).indexOf('&'))? optionList[i]: sumlyHSUnescapeEntities(optionList[i]);
		ctl.options[j++] = new Option(optionText, i, false, false);
	}
	if(sumlyHSPrefix[groupName] && ctl.options.length == 1)
		ctl.options.length = 0;
}

function sumly_HSSetValue(ctl, value)
{
	var testValue = {};
	if(value instanceof Array) {
		for(var i = 0; i < value.length; i++)
			testValue[value[i]] = true;
	}
	else
		testValue[value] = true;
	for(var i = 0; i < ctl.options.length; i++) {
		if(ctl.options[i].value in testValue)
			ctl.options[i].selected = true;
	}
}

function sumlyHSSwapOptions(form, groupName, selectIndex)
{
	var hsValue = [];
	for(var i = 0; i <= selectIndex; i++)
		hsValue[i] = document.getElementById(groupName + '['+i+']').value;
	for(var i = selectIndex + 1; i < sumlyHSOptions[sumlyHSCatName[groupName]].length; i ++)
		document.getElementById(groupName + '['+i+']').options.length = 0;

	var opts = sumlyHSFindOptions(sumlyHSOptions[sumlyHSCatName[groupName]][selectIndex+1], hsValue);
	if(typeof opts == 'object') {
		sumlyHSReplaceOptions(document.getElementById(groupName + '['+(selectIndex + 1)+']'), opts, groupName);
		if(selectIndex < sumlyHSOptions[sumlyHSCatName[groupName]].length - 1)
			sumlyHSSwapOptions(form, groupName, selectIndex + 1);
	}
}

function sumlyHS_Search(ary, id, finlev, curlev)
{
	if(finlev == curlev) {
		if(id in ary) {
			sumlyHStmp[finlev] = id;
			return true;
		}
	}
	else {
		for(key in ary) {
			sumlyHStmp[curlev] = key;
			if(sumlyHS_Search(ary[key], id, finlev, curlev + 1))
				return true;
		}
	}
	return false;
}

function sumlyHSSearch(catName, id, prefix)
{
	if(!id) {
		if(id != undefined && prefix)
			return [''];
	}
	else {
		var n = sumlyHSOptions[catName].length;
		for(var i = 0; i < n; i ++) {
			sumlyHStmp.length = 0;
			if(sumlyHS_Search(sumlyHSOptions[catName][i],id,i,0)) {
				if(prefix) {
					if(sumlyHStmp.length < n)
						sumlyHStmp[sumlyHStmp.length] = '';
				}
				return sumlyHStmp;
			}
		}
	}
	return [];
}

function sumlyHSGetPath(catName, idpath)
{
	var kl = idpath.length;
	var opttext = [];
	for(var i = 0; i < kl; i ++) {
		var hsValue = [i];
		for(var j = 0; j <= i; j ++)
			hsValue[j+1] = idpath[j];
		opttext[i] = sumlyHSFindOptions(sumlyHSOptions[catName],hsValue);
	}
	return opttext;
}

function sumlyMultiHSAddOption(rgroupName)
{
	var groupName = '_' + rgroupName;
	var ctl = document.getElementById(rgroupName + '[]');

	var opttext;
	var id;

	if(document.getElementById(groupName + '[0]').value == '') {
		opttext = TopCatLevel;
		id = 1;
	}
	else {
		var n = sumlyHSOptions[sumlyHSCatName[groupName]].length;
		var idpath = [];
		var idpath2 = [];
		for(var i = 0; i < n; i ++) {
			var t = document.getElementById(groupName + '['+i+']').value;
			if(!t)
				break;
			idpath2[i] = idpath[i] = t;
		}

		id = idpath[idpath.length-1];
		if(!document.getElementById(groupName + '[0]').getAttribute("AllKeys") && sumlyHSFindOptions(sumlyHSOptions[sumlyHSCatName[groupName]][idpath.length],idpath) != undefined)
			return;

		opttext = sumlyHSGetPath(sumlyHSCatName[groupName],idpath2).join(' > ');
	}

	var n = ctl.options.length;
	for(var i = 0; i < n; i ++) {
		if(id == ctl.options[i].value)
			return;
	}

	ctl.options[n] = new Option(opttext, id, false, false);
}

function sumlyMultiHSDeleteOption(rgroupName)
{
	var ctl = document.getElementById(rgroupName + '[]');
	var id = ctl.value;
	var n = ctl.options.length;
	for(var i = 0; i < n; i ++) {
		if(id == ctl.options[i].value) {
			ctl.options[i] = null;
			return;
		}
	}
}

function sumlyMultiHSSetValues(rgroupName, values)
{
	if(typeof values == 'object') {
		var groupName = '_' + rgroupName;
		var ctl = document.getElementById(rgroupName + '[]');
		ctl.options.length = 0;
		var n = values.length;
		for(var i = 0; i < n; i ++) {
			var opttext = [];
			var idpath = sumlyHSSearch(sumlyHSCatName[groupName], values[i], sumlyHSPrefix[groupName]);
			var kl = idpath.length;
			for(var j = 0; j < kl; j ++) {
				var hsValue = [];
				for(var k = 0; k <= j; k ++)
					hsValue[k] = idpath[k];
				var t = sumlyHSFindOptions(sumlyHSOptions[sumlyHSCatName[groupName]][j],hsValue);
				if(t)
					opttext[j] = t;
			}
			if(values[i] == 1)
				ctl.options[i] = new Option(TopCatLevel, values[i], false, false);
			else
				ctl.options[i] = new Option(opttext.join(' > '), values[i], false, false);
		}
	}
}

function sumlyMultiHSChangeState(rgroupName, state)
{
	var groupName = '_' + rgroupName;
	document.getElementById(rgroupName + '[]').style.display = state;
	var n = sumlyHSOptions[sumlyHSCatName[groupName]].length;
	if(n == 0)
		n = 1;
	for(var i = 0; i < n; i ++)
		document.getElementById(groupName+'['+i+']').style.display = state;
	document.getElementById('_a'+groupName).style.display = state;
	document.getElementById('_r'+groupName).style.display = state;
}

function sumlyHSSetValue(groupName, userprefix, value)
{
	var prefix;
	if(userprefix)
		prefix = sumlyHSPrefix[groupName];
	var value;
	if(typeof value != 'object')
		value = sumlyHSSearch(sumlyHSCatName[groupName], value, prefix);


	var n = sumlyHSOptions[sumlyHSCatName[groupName]].length;
	if(n > 0 && value.length > 0) {
		for(var i = 0; i < n; i ++) {
			if(value[i] == undefined && prefix)
				continue;
			var hsValue = [i];
			for(var j = 0; j < i; j ++)
				hsValue[j+1] = value[j];
			sumlyHSReplaceOptions(document.getElementById(groupName+'['+i+']'),sumlyHSFindOptions(sumlyHSOptions[sumlyHSCatName[groupName]],hsValue),groupName);
		}
	}
	else {
		if(sumlyHSOptions[sumlyHSCatName[groupName]].length == 0)
			document.getElementById(groupName+'[0]').options[0] = new Option(sumlyHSPrefix[groupName],'',false,false);
		else
			sumlyHSReplaceOptions(document.getElementById(groupName+'[0]'),sumlyHSFindOptions(sumlyHSOptions[sumlyHSCatName[groupName]],[0]),groupName);
	}

	for(var i = 0; i < value.length; i ++) {
		if(value[i] == undefined)
			break;
		sumly_HSSetValue(document.getElementById(groupName+'['+i+']'), value[i]);
	}
}

function sumlyHSInit(groupName, userprefix)
{
	sumlyHSSetValue(groupName, userprefix, sumlyHSDefaults[groupName]);
}

var sumlyHStmp=[];
var sumlyHSCatName = {};
var sumlyHSPrefix = {};
var sumlyHSOptions = {};
var sumlyHSDefaults = {};